#!/bin/bash
set -euo pipefail

source .env
GOCRYPTFS_PASSFILE=${GOCRYPTFS_ROOT_DIR:-~/.keys/gocrypts}/gocryptfs.key
GOCRYPTFS_OUTPUT_MOUNT=${GOCRYPTFS_MOUNT_ROOT:-~/.mnt}

gcfs-mount () {
    if [ "$1" == "data" ]; then
        GOCRYPTFS_CONFIG="${GOCRYPTFS_ROOT_DIR}/data-cipher/gocryptfs.conf"

        if [ -v "$2" ]; then
          GOCRYPTFS_VAULT="${HOME}/.${2}"


          if ! [ -f "${HOME}/.mnt/${2}" ]; then
            mkdir -p "${HOME}/.mnt/${2}"
            GOCRYPTFS_VOLUME="${GOCRYPTFS_OUTPUT_MOUNT}/${2}"
          fi
        else
          GOCRYPTFS_VAULT=~/.data

          if ! [ -f ~/.mnt/data ]; then
            mkdir -p ~/.mnt/data
            GOCRYPTFS_VOLUME="${GOCRYPTFS_OUTPUT_MOUNT}/data"
          fi
        fi
    fi

    if [ "$1" == "classified" ]; then
        GOCRYPTFS_CONFIG="${GOCRYPTFS_ROOT_DIR}/secret-cipher/gocryptfs.conf"

        if [ -v "$2" ]; then
          GOCRYPTFS_VAULT_ARG="${HOME}/Documents/.${2}"

          if ! [ -f "${HOME}/.mnt/${2}" ]; then
            mkdir -p "${HOME}/.mnt/${2}"
            GOCRYPTFS_VOLUME="${GOCRYPTFS_OUTPUT_MOUNT}/${2}"
          fi
        else
          GOCRYPTFS_VAULT_ARG=~/Documents/.secret

          if ! [ -f ~/.mnt/classified ]; then
            mkdir -p ~/.mnt/classified
            GOCRYPTFS_VOLUME="${GOCRYPTFS_OUTPUT_MOUNT}/classified"
          fi
        fi
    fi

    if [ "$1" == "works-in-progress" ]; then
        GOCRYPTFS_CONFIG="${GOCRYPTFS_ROOT_DIR}/wip-cipher/gocryptfs.conf"

        if [ -v "$2" ]; then
          GOCRYPTFS_VAULT="${HOME}/Portfolio/.${2}"

          if ! [ -f "${HOME}/.mnt/${2}" ]; then
            mkdir -p "${HOME}/.mnt/${2}"
            GOCRYPTFS_VOLUME="${GOCRYPTFS_OUTPUT_MOUNT}/${2}"
          fi
        else
          GOCRYPTFS_VAULT=~/Portfolio/.wip

          if ! [ -f ~/.mnt/works-in-progress ]; then
            mkdir -p ~/.mnt/works-in-progress
            GOCRYPTFS_VOLUME="${GOCRYPTFS_OUTPUT_MOUNT}/works-in-progress"
          fi
        fi
    fi

    gocryptfs -config "$GOCRYPTFS_CONFIG" -passfile "$GOCRYPTFS_PASSFILE" "$GOCRYPTFS_VAULT" "$GOCRYPTFS_VOLUME"
}

gcfs-umount () {
    if [ -v "$1" ]; then
      GOCRYPTFS_PLAIN="${GOCRYPTFS_OUTPUT_MOUNT}/${1}"
    else
      exit 1
    fi

    fusermount -u "$GOCRYPTFS_PLAIN"
}

#  znap () {
#      DATE_OF_ZFS_SNAPSHOT=$(date '+%Y%m%d%H%M%S')
#  
#      if [ -z "$1" ]; then
#          exit 1
#      elif [ "$1" == "essential" ]; then
#          sudo zfs snapshot "zroot${HOME}@${DATE_OF_ZFS_SNAPSHOT}"
#          sudo zfs snapshot "zroot${HOME}/.config@${DATE_OF_ZFS_SNAPSHOT}"
#          sudo zfs snapshot "zroot${HOME}/.var/app@${DATE_OF_ZFS_SNAPSHOT}"
#          sudo zfs snapshot "zroot${HOME}/.local/share/flatpak@${DATE_OF_ZFS_SNAPSHOT}"
#          sudo zfs snapshot "zroot/var/lib/nfs@${DATE_OF_ZFS_SNAPSHOT}"
#          sudo zfs snapshot "zroot/var/lib/NetworkManager@${DATE_OF_ZFS_SNAPSHOT}"
#          sudo zfs snapshot "zroot/keystore@${DATE_OF_ZFS_SNAPSHOT}"
#          sudo zfs snapshot "zroot/srv@${DATE_OF_ZFS_SNAPSHOT}"
#          sudo zfs snapshot "zroot/var/games@${DATE_OF_ZFS_SNAPSHOT}"
#          sudo zfs snapshot "zroot/var/mail@${DATE_OF_ZFS_SNAPSHOT}"
#          sudo zfs snapshot "zroot/var/www@${DATE_OF_ZFS_SNAPSHOT}"
#          sudo zfs snapshot "zroot/usr/local@${DATE_OF_ZFS_SNAPSHOT}"
#          sudo zfs snapshot "zroot/var/lib/AccountsService@${DATE_OF_ZFS_SNAPSHOT}"
#          sudo zfs snapshot -r "medialib@${DATE_OF_ZFS_SNAPSHOT}"
#          zfs list -t snapshot
#          # @NOTE: reccommended w option for zfs send
#      else
#          sudo zfs snapshot "${1}@${DATE_OF_ZFS_SNAPSHOT}"
#          zfs list -t snapshot | grep "$1"
#      fi
#  }