#!/bin/bash
set -euo pipefail

source .env
GOCRYPTFS_PASSFILE=${GOCRYPTFS_ROOT_DIR:-~/.keys/gocrypts}/gocryptfs.key
GOCRYPTFS_OUTPUT_MOUNT=${GOCRYPTFS_MOUNT_ROOT:-~/.mnt}

gcfs-mount () {
    if [ "$1" == "data" ]; then
        GOCRYPTFS_CONFIG="${GOCRYPTFS_ROOT_DIR}/data-cipher/gocryptfs.conf"

        if [ -v "$2" ]; then
          GOCRYPTFS_VAULT="${HOME}/.${2}"


          if ! [ -f "${HOME}/.mnt/${2}" ]; then
            mkdir -p "${HOME}/.mnt/${2}"
            GOCRYPTFS_VOLUME="${GOCRYPTFS_OUTPUT_MOUNT}/${2}"
          fi
        else
          GOCRYPTFS_VAULT=~/.data

          if ! [ -f ~/.mnt/data ]; then
            mkdir -p ~/.mnt/data
            GOCRYPTFS_VOLUME="${GOCRYPTFS_OUTPUT_MOUNT}/data"
          fi
        fi
    fi

    if [ "$1" == "classified" ]; then
        GOCRYPTFS_CONFIG="${GOCRYPTFS_ROOT_DIR}/secret-cipher/gocryptfs.conf"

        if [ -v "$2" ]; then
          GOCRYPTFS_VAULT_ARG="${HOME}/Documents/.${2}"

          if ! [ -f "${HOME}/.mnt/${2}" ]; then
            mkdir -p "${HOME}/.mnt/${2}"
            GOCRYPTFS_VOLUME="${GOCRYPTFS_OUTPUT_MOUNT}/${2}"
          fi
        else
          GOCRYPTFS_VAULT_ARG=~/Documents/.secret

          if ! [ -f ~/.mnt/classified ]; then
            mkdir -p ~/.mnt/classified
            GOCRYPTFS_VOLUME="${GOCRYPTFS_OUTPUT_MOUNT}/classified"
          fi
        fi
    fi

    if [ "$1" == "works-in-progress" ]; then
        GOCRYPTFS_CONFIG="${GOCRYPTFS_ROOT_DIR}/wip-cipher/gocryptfs.conf"

        if [ -v "$2" ]; then
          GOCRYPTFS_VAULT="${HOME}/Portfolio/.${2}"

          if ! [ -f "${HOME}/.mnt/${2}" ]; then
            mkdir -p "${HOME}/.mnt/${2}"
            GOCRYPTFS_VOLUME="${GOCRYPTFS_OUTPUT_MOUNT}/${2}"
          fi
        else
          GOCRYPTFS_VAULT=~/Portfolio/.wip

          if ! [ -f ~/.mnt/works-in-progress ]; then
            mkdir -p ~/.mnt/works-in-progress
            GOCRYPTFS_VOLUME="${GOCRYPTFS_OUTPUT_MOUNT}/works-in-progress"
          fi
        fi
    fi

    gocryptfs -config "$GOCRYPTFS_CONFIG" -passfile "$GOCRYPTFS_PASSFILE" "$GOCRYPTFS_VAULT" "$GOCRYPTFS_VOLUME"
}

gcfs-umount () {
    if [ -v "$1" ]; then
      GOCRYPTFS_PLAIN="${GOCRYPTFS_OUTPUT_MOUNT}/${1}"
    else
      exit 1
    fi

    fusermount -u "$GOCRYPTFS_PLAIN"
}