#!/bin/bash
set -euo pipefail

source .env
SSL_FQDN=${SSL_DOMAIN:?Insert hostname this certificate is for}
SSL_COMMON_NAME=${SSL_INPUT:?Insert common name for this certificate}

printf "Creating self-signed SSL certificate...\n"
openssl req -x509 -nodes -newkey rsa:2048 -keyout "/usr/local/share/ca-certificates/${SSL_FQDN}.key" -out "/usr/local/share/ca-certificates/${SSL_FQDN}.crt" -days 365 -subj "/CN=${SSL_COMMON_NAME}"
printf "Updating system's trusted certificates...\n"
update-ca-certificates