#!/bin/bash
set -euo pipefail


if [[ "${*}" == *--steam* ]]; then
	steamDir="${HOME}/.var/app/com.valvesoftware.Steam"
	xivlauncherDir="${steamDir}/.xlcore"
	ffxivDir="${steamDir}/.local/share/Steam/steamapps/common/FINAL FANTASY XIV Online"
else
	xivlauncherDir="${HOME}/.xlcore"
	ffxivDir="${xivlauncherDir}/ffxiv"
fi


if [[ "${*}" == *--steam* ]]; then
	export MAIN_PATH="${steamDir}/.local/share/reshade"
fi

export RESHADE_ADDON_SUPPORT=1

printf \
	'\nDownloading reshade-linux.sh...\n'

curl \
	-#LOC- \
	--output-dir '/tmp' \
	'https://github.com/kevinlekiller/reshade-steam-proton/raw/main/reshade-linux.sh'

printf \
	'\nDownloading gposingway.zip...\n'

curl \
	-#LOC- \
	--output-dir '/tmp' \
	'https://github.com/gposingway/gposingway/releases/latest/download/gposingway.zip'

printf \
	'\nDownloading d3dx9.tar.xz...\n'

curl \
	-#LOC- \
		--output-dir '/tmp' \
		'https://proxy.usebottles.com/redistributable/dependencies/d3dx9.tar.xz'

printf \
	"\nFFXIV game path:\n${ffxivDir}/game\n\nPress [Enter] to continue\n\n"

read -r

bash \
	'/tmp/reshade-linux.sh'

if [[ -e "${ffxivDir}/game/ReShade.ini" ]] && [[ ! -e "${ffxivDir}/game/ReShade.ini.bak" ]]; then
	mv \
		"${ffxivDir}/game/ReShade.ini" \
		"${ffxivDir}/game/ReShade.ini.bak"

	printf \
		'\nRenamed ReShade.ini to ReShade.ini.bak\n'
fi

printf '\nExtracting gposingway.zip...\n'

7z \
	x \
	-aos \
	-o"${ffxivDir}/game" \
	'/tmp/gposingway.zip' \
	&> /dev/null

if [[ -e "${xivlauncherDir}/wineprefix/drive_c/windows/system32/d3dcompiler_47.dll" ]] && [[ ! -e "${xivlauncherDir}/wineprefix/drive_c/windows/system32/d3dcompiler_47.dll.bak" ]]; then
	mv \
		"${xivlauncherDir}/wineprefix/drive_c/windows/system32/d3dcompiler_47.dll" \
		"${xivlauncherDir}/wineprefix/drive_c/windows/system32/d3dcompiler_47.dll.bak"

	printf \
		'\nRenamed d3dcompiler_47.dll to d3dcompiler_47.dll.bak\n'

	tar \
		--directory "${xivlauncherDir}/wineprefix/drive_c/windows/system32/" \
		--extract \
		--skip-old-files \
		--strip-components 2 \
		--file '/tmp/d3dx9.tar.xz' \
		'd3dx9/win32/d3dcompiler_47.dll'

	printf \
		'\nExtracted d3dcompiler_47.dll\n'
fi

rm \
	'/tmp/reshade-linux.sh'

rm \
	'/tmp/gposingway.zip'

rm \
	'/tmp/d3dx9.tar.xz'

printf '\nReShade & GPosingWay have been installed\n\n'